/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.ArrayDeque;

public final class FlowableSkipLast<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int skip;

    public FlowableSkipLast(Flowable<T> source, int skip) {
        super(source);
        this.skip = skip;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new SkipLastSubscriber<T>(s, this.skip));
    }

    static final class SkipLastSubscriber<T>
    extends ArrayDeque<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3807491841935125653L;
        final Subscriber<? super T> downstream;
        final int skip;
        Subscription upstream;

        SkipLastSubscriber(Subscriber<? super T> actual, int skip) {
            super(skip);
            this.downstream = actual;
            this.skip = skip;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.skip == this.size()) {
                this.downstream.onNext(this.poll());
            } else {
                this.upstream.request(1L);
            }
            this.offer(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

